config.widgets.module('number',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-config-number',
            template: '#config-number',
            props: {
                label: {
                    required: true,
                    type: String
                },
                defaultValue: {
                    type: String
                }
            },
            methods: {
                getPhrase(title) {
                    const phraseSection = title.split('.');
                    const section = phraseSection[0];
                    const phrase = phraseSection[1];

                    return jse.core.lang.translate(phrase, section);
                }
            },
            data() {
                return {
                    input: this.defaultValue
                }
            },
            watch: {
                input(val) {
                    this.$emit('input', val);
                }
            },
            init: done => done()
        }
    });